<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientesTable extends Migration {

	public function up()
	{
		Schema::create('clientes', function(Blueprint $table) {
			$table->increments('clientes_id');
			$table->integer('contatos_id')->unsigned();
			$table->integer('empresas_id')->unsigned();
			$table->string('nome', 100);
			$table->string('email', 60)->nullable();
			$table->string('cpf', 20);
			$table->string('rg', 20)->nullable();
			$table->enum('sexo', array('Masculino', 'Feminino'));
			$table->date('data_nascimento')->nullable();
			$table->string('pai', 100)->nullable();
			$table->string('mae', 100)->nullable();
			$table->boolean('aceitar_email')->default(1);
			$table->string('observacao', 255)->nullable();
			$table->boolean('ativo')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clientes');
	}
}