<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Matriculas extends Model 
{

    protected $table = 'matriculas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('termo', 'observacao', 'ativo');

    public function cliente()
    {
        return $this->belongsTo('Clientes', 'clientes_id');
    }

    public function turma()
    {
        return $this->belongsTo('Turmas', 'turmas_id');
    }

    public function frequencias()
    {
        return $this->hasMany('Frequencias', 'frequencias_id');
    }

}