<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Contatos extends Model 
{

    protected $table = 'contatos';
    public $timestamps = true;
    protected $fillable = array('cep', 'estado', 'cidade', 'bairro', 'logradouro', 'numero', 'complemento', 'telefone', 'celular', 'email', 'facebook');

    public function empresa()
    {
        return $this->belongsTo('Empresas', 'empresas_id');
    }

    public function clientes()
    {
        return $this->belongsTo('Clientes', 'clientes_id');
    }

    public function professor()
    {
        return $this->belongsTo('Professores', 'professores_id');
    }

}