<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Professores extends Eloquent {

	protected $table = 'professores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nome', 'cpf', 'rg', 'ativo');

	public function contato()
	{
		return $this->hasOne('Contatos', 'contatos_id');
	}

	public function turmas()
	{
		return $this->hasMany('Turmas', 'turmas_id');
	}

}