<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cupons extends Eloquent {

	protected $table = 'cupons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nota_fiscal', 'data_compra', 'valor_compra', 'data_impressao', 'quantidade_cupons', 'observacao', 'ativo');

	public function promocao()
	{
		return $this->belongsTo('Promocoes', 'promocoes_id');
	}

	public function cliente()
	{
		return $this->belongsTo('Clientes', 'clientes_id');
	}

}