<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatriculasTable extends Migration {

	public function up()
	{
		Schema::create('matriculas', function(Blueprint $table) {
			$table->increments('matriculas_id');
			$table->integer('clientes_id')->unsigned();
			$table->integer('turmas_id')->unsigned();
			$table->boolean('termo')->default(1);
			$table->string('observacao', 1000)->nullable();
			$table->boolean('ativo')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('matriculas');
	}
}