<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCuponsTable extends Migration {

	public function up()
	{
		Schema::create('cupons', function(Blueprint $table) {
			$table->increments('cupons_id');
			$table->integer('clientes_id')->unsigned();
			$table->integer('promocoes_id')->unsigned();
			$table->string('nota_fiscal', 340);
			$table->datetime('data_compra');
			$table->decimal('valor_compra', 15,2);
			$table->datetime('data_impressao')->nullable();
			$table->smallInteger('quantidade_cupons');
			$table->string('observacao', 255)->nullable();
			$table->boolean('ativo')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cupons');
	}
}