<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Request extends Model 
{

    protected $table = 'requests';
    public $timestamps = true;
    protected $fillable = array('service_id');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function budget()
    {
        return $this->belongsTo('Budget', 'budget_id');
    }

    public function duration()
    {
        return $this->belongsTo('Duration', 'duration_id');
    }

}