<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRejectReasonTable extends Migration {

	public function up()
	{
		Schema::create('reject_reason', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->longText('reason');
			$table->enum('type', array('Newjoiner', 'Withdrawal', 'Upgrade'));
			$table->integer('current_plan')->nullable();
			$table->integer('amount')->nullable();
			$table->bigInteger('decline_by')->unsigned();
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reject_reason');
	}
}