<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_group');
			$table->integer('id_user');
			$table->integer('id_wallet');
			$table->string('amount', 200);
			$table->string('status', 2)->default('0');
			$table->string('message', 600);
			$table->string('membership_price_usd', 200)->nullable();
			$table->string('membership_alt_coin', 100)->nullable();
			$table->string('membership_alt_coin_price_net')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}