<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function position()
	{
		return $this->belongsTo('Position', 'fk_position_id');
	}

	public function place()
	{
		return $this->belongsTo('Place', 'fk_place_id');
	}

}