<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Meeting extends Eloquent {

	protected $table = 'meetings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function company()
	{
		return $this->belongsTo('Company', 'fk_company_id');
	}

	public function tasks()
	{
		return $this->hasMany('MeetingTask');
	}

	public function receiversRepresentatives()
	{
		return $this->hasMany('Representative');
	}

	public function receiversUsers()
	{
		return $this->hasMany('User');
	}

}