<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type()
	{
		return $this->belongsTo('CompanyType', 'fk_company_type_id');
	}

	public function scope()
	{
		return $this->belongsToMany('Country', 'company_countries_pivot');
	}

	public function contract()
	{
		return $this->belongsTo('Contract', 'fk_contract_id');
	}

	public function meetings()
	{
		return $this->hasMany('Meeting');
	}

	public function sessions()
	{
		return $this->hasMany('Session');
	}

}