<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFeaturesTable extends Migration {

	public function up()
	{
		Schema::create('features', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->enum('type', array('size', 'dimension', 'color'));
			$table->tinyInteger('status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('features');
	}
}