<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('userpremios', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('userpremios', function(Blueprint $table) {
			$table->foreign('premio_id')->references('id')->on('premios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amigos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('userpremios', function(Blueprint $table) {
			$table->dropForeign('userpremios_user_id_foreign');
		});
		Schema::table('userpremios', function(Blueprint $table) {
			$table->dropForeign('userpremios_premio_id_foreign');
		});
		Schema::table('amigos', function(Blueprint $table) {
			$table->dropForeign('amigos_user_id_foreign');
		});
	}
}