<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePermissionRequestsTable extends Migration {

	public function up()
	{
		Schema::create('permission_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->integer('manager_id');
			$table->string('date');
			$table->text('note');
			$table->string('permission_number');
			$table->enum('manager_status', array(''));
			$table->integer('duration');
			$table->enum('hr_status', array(''));
			$table->double('deduct_amount')->nullable();
			$table->timestamp('manager_action_at')->nullable();
			$table->timestamp('hr_action_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('permission_requests');
	}
}