<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeductsTable extends Migration {

	public function up()
	{
		Schema::create('deducts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id');
			$table->text('note')->nullable();
			$table->enum('duration_type', array(''))->nullable();
			$table->double('duration')->nullable();
			$table->double('amount');
			$table->enum('status', array(''));
			$table->date('deducted_at');
			$table->date('aproved_at')->nullable();
			$table->enum('action_type', array(''));
			$table->timestamps();
			$table->integer('alter_employee_id');
		});
	}

	public function down()
	{
		Schema::drop('deducts');
	}
}