<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('category_name');
			$table->text('category_image')->nullable();
			$table->enum('delete_status', array('1', '0'));
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}