<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Clinic extends Eloquent {

	protected $table = 'clinics';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('number', 'name', 'group_id', 'date_opened', 'quickbase_id', 'quickbase_company');
	protected $visible = array('number', 'name', 'group_id', 'date_opened', 'quickbase_id', 'quickbase_company');

	public function locations()
	{
		return $this->hasMany('Location');
	}

	public function websites()
	{
		return $this->hasMany('Website');
	}

	public function zipcodes()
	{
		return $this->hasMany('Zipcode');
	}

	public function analyticsclients()
	{
		return $this->hasMany('Analyticsclient', 'clinic_id', 'id');
	}

	public function adsclients()
	{
		return $this->hasMany('Adsclient', 'user_id', 'id');
	}

}