<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerOrdersTable extends Migration {

	public function up()
	{
		Schema::create('mer_orders', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('order_number', 255)->nullable();
			$table->string('tracking_number', 255)->nullable();
			$table->double('total')->nullable();
			$table->double('shiping')->nullable();
			$table->double('tax')->nullable();
			$table->double('sub_total')->nullable();
			$table->string('weight', 255)->nullable();
			$table->string('quantity', 255)->nullable();
			$table->tinyInteger('status')->default('0');
			$table->text('status_detail')->nullable();
			$table->bigInteger('address_id')->unsigned()->nullable();
			$table->bigInteger('customer_id')->unsigned()->nullable();
			$table->string('address', 255)->nullable();
			$table->string('lat', 255)->nullable();
			$table->string('long', 255)->nullable();
			$table->string('phone1', 255)->nullable();
			$table->string('phone2', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->string('extra4', 255)->nullable();
			$table->text('note')->nullable();
			$table->string('scope', 255)->nullable();
			$table->bigInteger('offer_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_orders');
	}
}