<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerOrderItemAttrTable extends Migration {

	public function up()
	{
		Schema::create('mer_order_item_attr', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('order_item_id')->nullable();
			$table->string('total', 255)->nullable();
			$table->string('weight', 255)->nullable();
			$table->string('attribute_value', 255)->nullable();
			$table->bigInteger('attribute_id')->unsigned()->nullable();
			$table->string('attribute_code', 255)->nullable();
			$table->string('attribute_name', 255)->nullable();
			$table->string('attribute_unit_cost', 255)->nullable();
			$table->double('attribute_unit_price')->nullable();
			$table->string('attribute_weight')->nullable();
			$table->bigInteger('option_id')->nullable();
			$table->string('option_name', 255)->nullable();
			$table->double('option_cost')->nullable();
			$table->double('option_price')->nullable();
			$table->double('option_unit_price')->nullable();
			$table->string('option_weight', 255)->nullable();
			$table->text('note')->nullable();
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_order_item_attr');
	}
}