<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerOrderDeliveryTable extends Migration {

	public function up()
	{
		Schema::create('mer_order_delivery', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('order_number', 255)->nullable();
			$table->double('total')->nullable();
			$table->bigInteger('deliver_id')->unsigned()->nullable();
			$table->text('note')->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->string('extra4', 255)->nullable();
			$table->string('scope', 255);
		});
	}

	public function down()
	{
		Schema::drop('mer_order_delivery');
	}
}