<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShopsTable extends Migration {

	public function up()
	{
		Schema::create('shops', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100)->index();
			$table->boolean('is_business')->index();
			$table->string('email')->unique();
			$table->double('latitude')->index();
			$table->double('longitude')->index();
			$table->string('postocde', 7)->index();
			$table->integer('house_number')->unsigned()->index();
			$table->string('house_extension', 2)->nullable()->index();
			$table->string('street', 100)->index();
			$table->string('city', 100)->index();
			$table->string('image_path', 255)->nullable();
			$table->integer('user_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('shops');
	}
}