<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenuItemsTable extends Migration {

	public function up()
	{
		Schema::create('menu_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('menu_id')->unsigned();
			$table->string('name', 255);
			$table->string('description', 255);
			$table->integer('user_id')->unsigned();
			$table->integer('category_id')->unsigned()->index();
			$table->integer('price')->unsigned()->index();
			$table->smallInteger('order')->unsigned();
			$table->tinyInteger('max_free_extras')->unsigned()->nullable();
			$table->tinyInteger('max_paid_extras')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('menu_items');
	}
}