<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('phone', 10);
			$table->string('password');
			$table->string('email');
			$table->enum('role_type', array('Supervisor', 'Admin'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}