<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('invoice_date');
			$table->string('payment_method');
			$table->string('total_bill');
			$table->string('discount')->nullable();
			$table->text('customer_note')->nullable();
			$table->string('status')->default('pending');
			$table->bigInteger('customer_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}