<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('username', 200);
			$table->date('date_birth');
			$table->string('email', 200);
			$table->string('phone', 50);
			$table->string('hospital', 50);
			$table->string('address', 150);
			$table->integer('doctorid')->unsigned();
			$table->string('code', 10)->unique();
			$table->enum('gender', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}