<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tripe_id')->unsigned();
			$table->enum('rating', array('1', '2', '3', '4', '5'));
			$table->text('comment');
			$table->datetime('review_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}