<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePerformanceMatricesTable extends Migration {

	public function up()
	{
		Schema::create('performance_matrices', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->integer('customer_id')->unsigned();
			$table->smallInteger('network_id')->unsigned();
			$table->integer('campaign_id')->unsigned();
			$table->integer('ad_set_id')->unsigned();
			$table->integer('ad_id')->unsigned();
			$table->string('spend');
			$table->integer('impressions');
			$table->integer('clicks');
			$table->integer('reported_installs');
			$table->date('date');
			$table->decimal('cost_per_click', 10,2);
			$table->decimal('click_through_rate', 10,2);
			$table->decimal('cost_per_install', 10,2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('performance_matrices');
	}
}