<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 255)->nullable();
			$table->string('subject')->nullable();
			$table->string('content', 255);
			$table->enum('delete_status', array('0', '1'));
			$table->timestamps();
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
			$table->enum('status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}