<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('page_title_en', 255)->nullable();
			$table->string('page_title_ar', 255)->nullable();
			$table->string('meta_description_ar');
			$table->string('meta_description_en', 255)->nullable();
			$table->text('meta_keywords_ar');
			$table->text('meta_keywords_en');
			$table->string('link_ar');
			$table->string('title_en');
			$table->string('title_ar');
			$table->enum('delete_status', array('0', '1'));
			$table->timestamps();
			$table->integer('status');
			$table->text('description_ar');
			$table->text('description_en');
			$table->text('content_ar');
			$table->text('content_en');
			$table->integer('category_id')->unsigned();
			$table->integer('views');
			$table->enum('type', array('0', '1'));
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}