<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('delete_status', array('0', '1'));
			$table->string('username');
			$table->string('email', 255);
			$table->string('password');
			$table->string('image');
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
			$table->timestamps();
			$table->enum('status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}