<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_specializations', function(Blueprint $table) {
			$table->foreign('specialization_id')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_specializations', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('specializations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('request_elements', function(Blueprint $table) {
			$table->foreign('request_elements_id')->references('id')->on('request_elements_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('request_elements', function(Blueprint $table) {
			$table->foreign('request_element_unit_id')->references('id')->on('request_element_units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('camps', function(Blueprint $table) {
			$table->foreign('plot_id')->references('id')->on('plots')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_camps', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_camps', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_camps', function(Blueprint $table) {
			$table->foreign('establishment_camp_id')->references('id')->on('establishment_camps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('user_camp_id')->references('id')->on('organization_camps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('organization_camp_id')->references('id')->on('organization_camps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organizations', function(Blueprint $table) {
			$table->foreign('organization_specialization_id')->references('id')->on('organization_specializations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organizations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specialization_requirements', function(Blueprint $table) {
			$table->foreign('specialization_id')->references('id')->on('specializations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specialization_requirements', function(Blueprint $table) {
			$table->foreign('requirement_id')->references('id')->on('requirements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_req_forms', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_req_forms', function(Blueprint $table) {
			$table->foreign('specialization_requirement_id')->references('id')->on('specialization_requirements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specializations', function(Blueprint $table) {
			$table->foreign('organization_type_id')->references('id')->on('organization_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointment_status', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointment_status', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('organization_camp_id')->references('id')->on('organization_camps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_request_elements', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_request_elements', function(Blueprint $table) {
			$table->foreign('request_element_id')->references('id')->on('request_elements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_status', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointment_notes', function(Blueprint $table) {
			$table->foreign('appointment_note_type_id')->references('id')->on('appointment_note_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointment_note_forms', function(Blueprint $table) {
			$table->foreign('appointment_note_id')->references('id')->on('appointment_notes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointment_note_forms', function(Blueprint $table) {
			$table->foreign('appointment_statu_id')->references('id')->on('appointment_status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('camp_status', function(Blueprint $table) {
			$table->foreign('camp_id')->references('id')->on('camps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('camp_status', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('establishment_camps', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('establishment_camps', function(Blueprint $table) {
			$table->foreign('camp_id')->references('id')->on('camps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_offices', function(Blueprint $table) {
			$table->foreign('office_id')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organization_offices', function(Blueprint $table) {
			$table->foreign('est_id')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_organization_id_foreign');
		});
		Schema::table('organization_specializations', function(Blueprint $table) {
			$table->dropForeign('organization_specializations_specialization_id_foreign');
		});
		Schema::table('organization_specializations', function(Blueprint $table) {
			$table->dropForeign('organization_specializations_organization_id_foreign');
		});
		Schema::table('request_elements', function(Blueprint $table) {
			$table->dropForeign('request_elements_request_elements_id_foreign');
		});
		Schema::table('request_elements', function(Blueprint $table) {
			$table->dropForeign('request_elements_request_element_unit_id_foreign');
		});
		Schema::table('camps', function(Blueprint $table) {
			$table->dropForeign('camps_plot_id_foreign');
		});
		Schema::table('organization_camps', function(Blueprint $table) {
			$table->dropForeign('organization_camps_user_id_foreign');
		});
		Schema::table('organization_camps', function(Blueprint $table) {
			$table->dropForeign('organization_camps_organization_id_foreign');
		});
		Schema::table('organization_camps', function(Blueprint $table) {
			$table->dropForeign('organization_camps_establishment_camp_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_user_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_user_camp_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_organization_camp_id_foreign');
		});
		Schema::table('organizations', function(Blueprint $table) {
			$table->dropForeign('organizations_organization_specialization_id_foreign');
		});
		Schema::table('organizations', function(Blueprint $table) {
			$table->dropForeign('organizations_user_id_foreign');
		});
		Schema::table('specialization_requirements', function(Blueprint $table) {
			$table->dropForeign('specialization_requirements_specialization_id_foreign');
		});
		Schema::table('specialization_requirements', function(Blueprint $table) {
			$table->dropForeign('specialization_requirements_requirement_id_foreign');
		});
		Schema::table('organization_req_forms', function(Blueprint $table) {
			$table->dropForeign('organization_req_forms_user_id_foreign');
		});
		Schema::table('organization_req_forms', function(Blueprint $table) {
			$table->dropForeign('organization_req_forms_specialization_requirement_id_foreign');
		});
		Schema::table('specializations', function(Blueprint $table) {
			$table->dropForeign('specializations_organization_type_id_foreign');
		});
		Schema::table('appointment_status', function(Blueprint $table) {
			$table->dropForeign('appointment_status_appointment_id_foreign');
		});
		Schema::table('appointment_status', function(Blueprint $table) {
			$table->dropForeign('appointment_status_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_organization_camp_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_organization_id_foreign');
		});
		Schema::table('order_request_elements', function(Blueprint $table) {
			$table->dropForeign('order_request_elements_order_id_foreign');
		});
		Schema::table('order_request_elements', function(Blueprint $table) {
			$table->dropForeign('order_request_elements_request_element_id_foreign');
		});
		Schema::table('order_status', function(Blueprint $table) {
			$table->dropForeign('order_status_order_id_foreign');
		});
		Schema::table('appointment_notes', function(Blueprint $table) {
			$table->dropForeign('appointment_notes_appointment_note_type_id_foreign');
		});
		Schema::table('appointment_note_forms', function(Blueprint $table) {
			$table->dropForeign('appointment_note_forms_appointment_note_id_foreign');
		});
		Schema::table('appointment_note_forms', function(Blueprint $table) {
			$table->dropForeign('appointment_note_forms_appointment_statu_id_foreign');
		});
		Schema::table('camp_status', function(Blueprint $table) {
			$table->dropForeign('camp_status_camp_id_foreign');
		});
		Schema::table('camp_status', function(Blueprint $table) {
			$table->dropForeign('camp_status_user_id_foreign');
		});
		Schema::table('establishment_camps', function(Blueprint $table) {
			$table->dropForeign('establishment_camps_organization_id_foreign');
		});
		Schema::table('establishment_camps', function(Blueprint $table) {
			$table->dropForeign('establishment_camps_camp_id_foreign');
		});
		Schema::table('organization_offices', function(Blueprint $table) {
			$table->dropForeign('organization_offices_office_id_foreign');
		});
		Schema::table('organization_offices', function(Blueprint $table) {
			$table->dropForeign('organization_offices_est_id_foreign');
		});
	}
}