<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBooksTable extends Migration {

	public function up()
	{
		Schema::create('books', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('author_id')->unsigned();
			$table->string('slug', 255);
			$table->string('utf8_title', 255)->index();
			$table->string('ascii_title', 255);
			$table->string('byline', 255);
			$table->string('description', 255);
			$table->tinyInteger('page_count');
			$table->text('relative_path');
			$table->text('remote_path');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('books');
	}
}