<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpecialEventTable extends Migration {

	public function up()
	{
		Schema::create('special_event', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombre', 100)->unique();
			$table->date('date')->unique();
			$table->decimal('event_price', 10,4);
			$table->text('description')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('special_event');
	}
}