<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePermissionsTable extends Migration {

	public function up()
	{
		Schema::create('permissions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug')->unique();
			$table->string('name')->index();
			$table->text('description')->nullable();
			$table->text('config')->nullable();
			$table->boolean('enabled')->default(true);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('permissions');
	}
}