<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHotelLocationTable extends Migration {

	public function up()
	{
		Schema::create('hotel_location', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 150);
			$table->text('address');
			$table->text('collection_location');
			$table->time('collection_time');
			$table->integer('hotel_id')->unsigned();
			$table->timestamps();
			$table->boolean('enable')->default(true);
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('hotel_location');
	}
}