<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDirectSellsTable extends Migration {

	public function up()
	{
		Schema::create('direct_sells', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('seller_id')->unsigned();
			$table->decimal('grand_total', 10,4);
			$table->boolean('is_credit_card')->nullable();
			$table->timestamps();
			$table->string('cc_confirmation_code', 25)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('direct_sells');
	}
}