<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCurrencyConfigsTable extends Migration {

	public function up()
	{
		Schema::create('currency_configs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('currency_id')->unsigned();
			$table->string('key', 50);
			$table->decimal('value', 10,4);
			$table->boolean('enabled')->default(true);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('currency_configs');
	}
}