<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('username', 100)->unique();
			$table->string('name', 100);
			$table->string('last_name', 100);
			$table->string('email', 100)->unique();
			$table->string('password', 500);
			$table->string('picture', 500)->nullable();
			$table->string('register_ip', 15);
			$table->rememberToken();
			$table->string('forget_token', 100)->nullable();
			$table->string('activation_key', 100);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}