<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HotelRoute extends Model 
{

    protected $table = 'hotel_route';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function hotels()
    {
        return $this->hasMany('Hotel', 'id');
    }

    public function routes()
    {
        return $this->hasMany('Route', 'id');
    }

}