<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Voucher extends Eloquent {

	protected $table = 'vouchers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('voucher_group_id', 'status_id', 'user_id', 'client_id');

	public function invoice_group()
	{
		return $this->hasOne('VoucherGroup');
	}

	public function status()
	{
		return $this->hasOne('VoucherStatus');
	}

	public function client()
	{
		return $this->hasOne('Client');
	}

}