<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('ar_name', 191);
			$table->string('en_name', 191);
			$table->text('description');
			$table->string('price', 191);
			$table->integer('category_id')->unsigned();
			$table->string('amount', 191);
			$table->integer('sub_category_id')->unsigned();
			$table->string('image', 191);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}