<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 25);
			$table->string('email', 45);
			$table->date('birth_of_date');
			$table->string('phone', 15);
			$table->string('password', 45);
			$table->integer('blood_type_id');
			$table->integer('city_id');
			$table->string('pin_code', 8);
			$table->timestamps();
			$table->string('api_token', 255);
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}