<?php

namespace App/Models/MarketingSocial;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MarketingSocial extends Eloquent {

	protected $table = 'marketing_socials';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function main()
	{
		return $this->belongsTo('MarketingMain', 'marketing_id');
	}

	public function social()
	{
		return $this->belongsTo('Social', 'social_id');
	}

}