<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('answers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('language_key', 299);
			$table->integer('question_id')->unsigned();
			$table->tinyInteger('show_textbox')->default('0');
			$table->text('textbox_label')->nullable();
			$table->integer('image_id')->unsigned();
			$table->text('answer_en')->nullable();
			$table->text('answer_ind')->nullable();
			$table->text('answer_malay')->nullable();
			$table->text('answer_thai')->nullable();
			$table->text('answer_urdu')->nullable();
			$table->text('answer_burmese')->nullable();
			$table->text('answe_rohingya')->nullable();
			$table->text('answer_dari')->nullable();
			$table->text('answer_somali')->nullable();
			$table->text('answer_arabic')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('answers');
	}
}