<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('group_id');
			$table->integer('attribute_set_id');
			$table->string('name', 255);
			$table->text('description');
			$table->integer('text_id');
			$table->decimal('price');
			$table->string('sku', 100);
			$table->integer('stock');
			$table->tinyInteger('active');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}