<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('type');
			$table->string('name');
			$table->string('code');
			$table->string('project_type_id');
			$table->float('price');
			$table->integer('currency_id')->unsigned();
			$table->string('have_copy_project');
			$table->integer('copy_project_id')->unsigned()->nullable();
			$table->date('project_start_date');
			$table->date('project_end_date')->nullable();
			$table->integer('project_class_id');
			$table->string('logo');
			$table->longText('description');
			$table->string('status');
			$table->date('start_technical_support')->nullable();
			$table->date('end_technical_support')->nullable();
			$table->float('technical_support_duration');
			$table->string('technical_support_duration_type');
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}