<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('covenant_translations', function(Blueprint $table) {
			$table->foreign('covenant_id')->references('id')->on('covenants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('covenant_stocks', function(Blueprint $table) {
			$table->foreign('covenant_id')->references('id')->on('covenants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('covenant_stock_translations', function(Blueprint $table) {
			$table->foreign('covenant_stock_id')->references('id')->on('covenant_stocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('covenant_stock_option', function(Blueprint $table) {
			$table->foreign('covenant_stock_id')->references('id')->on('covenant_stocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('covenant_stock_option', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('options')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('option_translations', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('options')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription_translations', function(Blueprint $table) {
			$table->foreign('subscription_setting_id')->references('id')->on('subscription_settings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription_type_translations', function(Blueprint $table) {
			$table->foreign('subscription_type_id')->references('id')->on('subscription_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscription_settings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('copy_project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_categories', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_branches', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices_due', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_files', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_attached_data', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_platforms', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_links', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_links', function(Blueprint $table) {
			$table->foreign('project_platform_id')->references('id')->on('project_platforms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_plans', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_plans', function(Blueprint $table) {
			$table->foreign('step_id')->references('id')->on('steps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_steps', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_steps', function(Blueprint $table) {
			$table->foreign('step_id')->references('id')->on('steps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_step_groups', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_step_groups', function(Blueprint $table) {
			$table->foreign('project_step_id')->references('id')->on('project_steps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_members', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects_reports', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_testers', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('covenant_translations', function(Blueprint $table) {
			$table->dropForeign('covenant_translations_covenant_id_foreign');
		});
		Schema::table('covenant_stocks', function(Blueprint $table) {
			$table->dropForeign('covenant_stocks_covenant_id_foreign');
		});
		Schema::table('covenant_stock_translations', function(Blueprint $table) {
			$table->dropForeign('covenant_stock_translations_covenant_stock_id_foreign');
		});
		Schema::table('covenant_stock_option', function(Blueprint $table) {
			$table->dropForeign('covenant_stock_option_covenant_stock_id_foreign');
		});
		Schema::table('covenant_stock_option', function(Blueprint $table) {
			$table->dropForeign('covenant_stock_option_option_id_foreign');
		});
		Schema::table('option_translations', function(Blueprint $table) {
			$table->dropForeign('option_translations_option_id_foreign');
		});
		Schema::table('subscription_translations', function(Blueprint $table) {
			$table->dropForeign('subscription_translations_subscription_setting_id_foreign');
		});
		Schema::table('subscription_type_translations', function(Blueprint $table) {
			$table->dropForeign('subscription_type_translations_subscription_type_id_foreign');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->dropForeign('subscription_subscription_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_currency_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_copy_project_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_client_id_foreign');
		});
		Schema::table('project_categories', function(Blueprint $table) {
			$table->dropForeign('project_categories_project_id_foreign');
		});
		Schema::table('project_branches', function(Blueprint $table) {
			$table->dropForeign('project_branches_project_id_foreign');
		});
		Schema::table('invoices_due', function(Blueprint $table) {
			$table->dropForeign('invoices_due_invoice_id_foreign');
		});
		Schema::table('project_files', function(Blueprint $table) {
			$table->dropForeign('project_files_project_id_foreign');
		});
		Schema::table('project_attached_data', function(Blueprint $table) {
			$table->dropForeign('project_attached_data_project_id_foreign');
		});
		Schema::table('project_platforms', function(Blueprint $table) {
			$table->dropForeign('project_platforms_project_id_foreign');
		});
		Schema::table('project_links', function(Blueprint $table) {
			$table->dropForeign('project_links_project_id_foreign');
		});
		Schema::table('project_links', function(Blueprint $table) {
			$table->dropForeign('project_links_project_platform_id_foreign');
		});
		Schema::table('project_plans', function(Blueprint $table) {
			$table->dropForeign('project_plans_project_id_foreign');
		});
		Schema::table('project_plans', function(Blueprint $table) {
			$table->dropForeign('project_plans_step_id_foreign');
		});
		Schema::table('project_steps', function(Blueprint $table) {
			$table->dropForeign('project_steps_project_id_foreign');
		});
		Schema::table('project_steps', function(Blueprint $table) {
			$table->dropForeign('project_steps_step_id_foreign');
		});
		Schema::table('project_step_groups', function(Blueprint $table) {
			$table->dropForeign('project_step_groups_project_id_foreign');
		});
		Schema::table('project_step_groups', function(Blueprint $table) {
			$table->dropForeign('project_step_groups_project_step_id_foreign');
		});
		Schema::table('project_members', function(Blueprint $table) {
			$table->dropForeign('project_members_project_id_foreign');
		});
		Schema::table('projects_reports', function(Blueprint $table) {
			$table->dropForeign('projects_reports_project_id_foreign');
		});
		Schema::table('project_testers', function(Blueprint $table) {
			$table->dropForeign('project_testers_project_id_foreign');
		});
	}
}