<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sub_dispatches', function(Blueprint $table) {
			$table->foreign('price_basis_id')->references('id')->on('price_basis')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('sub_dispatch_id')->references('id')->on('sub_dispatches')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('transportations', function(Blueprint $table) {
			$table->foreign('sub_dispatch_id')->references('id')->on('sub_dispatches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('sub_dispatches', function(Blueprint $table) {
			$table->dropForeign('sub_dispatches_price_basis_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_sub_dispatch_id_foreign');
		});
		Schema::table('transportations', function(Blueprint $table) {
			$table->dropForeign('transportations_sub_dispatch_id_foreign');
		});
	}
}